/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

class ChooseACreature
extends OneShotEffect {
    public static final String INFO_KEY = "CHOSEN_CREATURE";

    public ChooseACreature() {
        super(Outcome.Copy);
        this.staticText = "choose a creature";
    }

    private ChooseACreature(ChooseACreature effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourceObject = game.getPermanentEntering(source.getSourceId());
        if (sourceObject == null) {
            sourceObject = game.getObject(source);
        }
        if (controller == null || sourceObject == null) {
            return false;
        }
        TargetCreaturePermanent target = new TargetCreaturePermanent();
        target.withNotTarget(true);
        if (!target.canChoose(controller.getId(), source, game)) {
            return true;
        }
        controller.choose(Outcome.Copy, (Target)target, source, game);
        Permanent chosenPermanent = game.getPermanent(target.getFirstTarget());
        if (chosenPermanent != null) {
            game.getState().setValue(source.getSourceId().toString() + INFO_KEY, (Object)chosenPermanent.copy());
        }
        return true;
    }

    public ChooseACreature copy() {
        return new ChooseACreature(this);
    }
}

