/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.LinkedHashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class ChooseLetterEffect
extends OneShotEffect {
    ChooseLetterEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a letter";
    }

    private ChooseLetterEffect(ChooseLetterEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent mageObject = game.getPermanentEntering(source.getSourceId());
        if (mageObject == null) {
            mageObject = game.getObject(source);
        }
        ChoiceImpl choice = new ChoiceImpl(true);
        choice.setMessage("Choose letter");
        LinkedHashSet<String> choices = new LinkedHashSet<String>();
        for (char letter = 'A'; letter <= 'Z'; letter = (char)(letter + '\u0001')) {
            choices.add(Character.toString(letter));
        }
        choice.setChoices(choices);
        if (controller != null && mageObject != null && controller.choose(this.outcome, (Choice)choice, game)) {
            if (!game.isSimulation()) {
                game.informPlayers(mageObject.getLogName() + ": " + controller.getLogName() + " has chosen " + choice.getChoice());
            }
            game.getState().setValue(mageObject.getId() + "_letter", (Object)choice.getChoice());
            if (mageObject instanceof Permanent) {
                mageObject.addInfo("chosen letter", CardUtil.addToolTipMarkTags((String)("Chosen letter: " + choice.getChoice())), game);
            }
            return true;
        }
        return false;
    }

    public ChooseLetterEffect copy() {
        return new ChooseLetterEffect(this);
    }
}

