/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;

class CounterSourceEffect
extends OneShotEffect {
    CounterSourceEffect() {
        super(Outcome.Detriment);
        this.staticText = "counter it unless you sacrifice a land";
    }

    private CounterSourceEffect(CounterSourceEffect effect) {
        super((OneShotEffect)effect);
    }

    public CounterSourceEffect copy() {
        return new CounterSourceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        StackObject spell = null;
        for (StackObject objet : game.getStack()) {
            if (!(objet instanceof Spell) || !objet.getSourceId().equals(source.getSourceId())) continue;
            spell = objet;
        }
        if (spell != null) {
            Player controller = game.getPlayer(source.getControllerId());
            if (controller != null && controller.chooseUse(Outcome.Detriment, "Sacrifice a land to not counter " + spell.getName() + '?', source, game)) {
                SacrificeTargetCost cost = new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_LAND);
                if (cost.pay(source, game, source, source.getControllerId(), false, null)) {
                    game.informPlayers(controller.getLogName() + " sacrifices a land to not counter " + spell.getName() + '.');
                    return true;
                }
                game.getStack().counter(spell.getId(), source, game);
            }
            return true;
        }
        return false;
    }
}

