/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.ArrayList;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

enum GatesWithDifferentNamesYouControlCount implements DynamicValue
{
    instance;


    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        ArrayList<String> names = new ArrayList<String>();
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(sourceAbility.getControllerId())) {
            if (!permanent.hasSubtype(SubType.GATE, game) || names.contains(permanent.getName())) continue;
            names.add(permanent.getName());
        }
        return names.size();
    }

    public GatesWithDifferentNamesYouControlCount copy() {
        return instance;
    }

    public String toString() {
        return "X";
    }

    public String getMessage() {
        return "Gates with different names you control";
    }
}

