/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.CardsInControllerHandCount;
import mage.abilities.effects.Effect;
import mage.game.Game;
import mage.players.Player;

class HighestLifeTotalAmongOpponentsCount
implements DynamicValue {
    HighestLifeTotalAmongOpponentsCount() {
    }

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        Player controller;
        if (sourceAbility != null && (controller = game.getPlayer(sourceAbility.getControllerId())) != null) {
            int max = 0;
            for (UUID uuid : game.getOpponents(controller.getId())) {
                Player opponent = game.getPlayer(uuid);
                if (opponent == null || opponent.getLife() <= max) continue;
                max = opponent.getLife();
            }
            return (int)Math.ceil((double)max / 2.0);
        }
        return 0;
    }

    public DynamicValue copy() {
        return CardsInControllerHandCount.ANY;
    }

    public String getMessage() {
        return "half the highest life total among your opponents, rounded up";
    }

    public String toString() {
        return "1";
    }
}

