/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class LukkaWaywardBonderDiscardEffect
extends OneShotEffect {
    LukkaWaywardBonderDiscardEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may discard a card. If you do, draw a card. If a creature card was discarded this way, draw two cards instead";
    }

    private LukkaWaywardBonderDiscardEffect(LukkaWaywardBonderDiscardEffect effect) {
        super((OneShotEffect)effect);
    }

    public LukkaWaywardBonderDiscardEffect copy() {
        return new LukkaWaywardBonderDiscardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.discard(0, 1, false, source, game).getRandom(game);
        if (card == null) {
            return false;
        }
        player.drawCards(card.isCreature(game) ? 2 : 1, source, game);
        return true;
    }
}

