/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashSet;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.InvertCondition;
import mage.abilities.condition.common.TargetAttackedThisTurnCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.m.MaddeningImpDelayedDestroyEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MaddeningImpCreateDelayedTriggeredAbilityEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public MaddeningImpCreateDelayedTriggeredAbilityEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "At the beginning of the next end step, destroy each of those creatures that didn't attack this turn";
    }

    private MaddeningImpCreateDelayedTriggeredAbilityEffect(MaddeningImpCreateDelayedTriggeredAbilityEffect effect) {
        super((OneShotEffect)effect);
    }

    public MaddeningImpCreateDelayedTriggeredAbilityEffect copy() {
        return new MaddeningImpCreateDelayedTriggeredAbilityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player != null) {
            HashSet<MageObjectReference> activeCreatures = new HashSet<MageObjectReference>();
            for (Permanent creature : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, player.getId(), game)) {
                if (creature == null) continue;
                activeCreatures.add(new MageObjectReference((MageObject)creature, game));
            }
            AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new MaddeningImpDelayedDestroyEffect(activeCreatures), TargetController.ANY, (Condition)new InvertCondition((Condition)TargetAttackedThisTurnCondition.instance));
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
            return true;
        }
        return false;
    }

    static {
        filter.add(Predicates.not((Predicate)SubType.WALL.getPredicate()));
        filter.add((ObjectSourcePlayerPredicate)TargetController.ACTIVE.getControllerPredicate());
    }
}

