/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.common.AttackedThisTurnWatcher;

class MaddeningImpDelayedDestroyEffect
extends OneShotEffect {
    private Set<MageObjectReference> activeCreatures;

    MaddeningImpDelayedDestroyEffect(Set<MageObjectReference> activeCreatures) {
        super(Outcome.DestroyPermanent);
        this.activeCreatures = activeCreatures;
        this.staticText = "At the beginning of the next end step, destroy each of those creatures that didn't attack this turn";
    }

    private MaddeningImpDelayedDestroyEffect(MaddeningImpDelayedDestroyEffect effect) {
        super((OneShotEffect)effect);
        this.activeCreatures = effect.activeCreatures;
    }

    public MaddeningImpDelayedDestroyEffect copy() {
        return new MaddeningImpDelayedDestroyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player != null) {
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents(player.getId())) {
                AttackedThisTurnWatcher watcher;
                MageObjectReference mor = new MageObjectReference((MageObject)permanent, game);
                if (!this.activeCreatures.contains(mor) || (watcher = (AttackedThisTurnWatcher)game.getState().getWatcher(AttackedThisTurnWatcher.class)) != null && watcher.getAttackedThisTurnCreatures().contains(mor)) continue;
                permanent.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }
}

