/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.cards.m.MaelstromMuseWatcher;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class MaelstromMuseEffect
extends CostModificationEffectImpl {
    private int spellsCast;
    private int sourcePower = 0;

    MaelstromMuseEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "the next instant or sorcery spell you cast this turn costs {X} less to cast, where X is {this}'s power as this ability resolves";
    }

    private MaelstromMuseEffect(MaelstromMuseEffect effect) {
        super((CostModificationEffectImpl)effect);
        this.spellsCast = effect.spellsCast;
        this.sourcePower = effect.sourcePower;
    }

    public void init(Ability source, Game game) {
        Permanent permanent;
        super.init(source, game);
        MaelstromMuseWatcher watcher = (MaelstromMuseWatcher)game.getState().getWatcher(MaelstromMuseWatcher.class);
        if (watcher != null) {
            this.spellsCast = watcher.getCount(source.getControllerId());
        }
        this.sourcePower = (permanent = source.getSourcePermanentOrLKI(game)) != null ? Math.max(permanent.getPower().getValue(), 0) : 0;
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost((Ability)abilityToModify, (int)this.sourcePower);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        MaelstromMuseWatcher watcher = (MaelstromMuseWatcher)game.getState().getWatcher(MaelstromMuseWatcher.class);
        if (watcher == null) {
            return false;
        }
        if (watcher.getCount(source.getControllerId()) > this.spellsCast) {
            this.discard();
            return false;
        }
        if (!(abilityToModify instanceof SpellAbility) || !abilityToModify.isControlledBy(source.getControllerId())) {
            return false;
        }
        Card spellCard = ((SpellAbility)abilityToModify).getCharacteristics(game);
        return spellCard != null && spellCard.isInstantOrSorcery(game);
    }

    public MaelstromMuseEffect copy() {
        return new MaelstromMuseEffect(this);
    }
}

