/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.m.MaestrosAscendancyWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.stack.Spell;

class MaestrosAscendancyExileEffect
extends ReplacementEffectImpl {
    MaestrosAscendancyExileEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Exile);
        this.staticText = "If a spell cast this way would be put into your graveyard, exile it instead";
    }

    private MaestrosAscendancyExileEffect(MaestrosAscendancyExileEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public MaestrosAscendancyExileEffect copy() {
        return new MaestrosAscendancyExileEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ((ZoneChangeEvent)event).setToZone(Zone.EXILED);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        Spell spell = game.getSpellOrLKIStack(zEvent.getTargetId());
        return zEvent.getToZone() == Zone.GRAVEYARD && spell != null && MaestrosAscendancyWatcher.checkSpell(spell, source, game);
    }
}

