/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.RandomUtil;

class MagesContestEffect
extends OneShotEffect {
    MagesContestEffect() {
        super(Outcome.Detriment);
        this.staticText = "You and target spell's controller bid life. You start the bidding with a bid of 1. In turn order, each player may top the high bid. The bidding ends if the high bid stands. The high bidder loses life equal to the high bid. If you win the bidding, counter that spell";
    }

    private MagesContestEffect(MagesContestEffect effect) {
        super((OneShotEffect)effect);
    }

    public MagesContestEffect copy() {
        return new MagesContestEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell != null) {
            Player you = game.getPlayer(source.getControllerId());
            Player spellController = game.getPlayer(spell.getControllerId());
            if (you != null && spellController != null) {
                int highBid = 1;
                game.informPlayers(you.getLogName() + " has bet " + highBid + " life");
                Player winner = you;
                Player currentPlayer = spellController;
                do {
                    if (!currentPlayer.canRespond()) continue;
                    int newBid = 0;
                    if (currentPlayer.isComputer()) {
                        int maxBid = Math.min(RandomUtil.nextInt((int)Math.max(currentPlayer.getLife(), 1)) + RandomUtil.nextInt((int)Math.max(spell.getManaValue(), 1)), currentPlayer.getLife());
                        if (highBid + 1 < maxBid) {
                            newBid = highBid + 1;
                        }
                    } else if (currentPlayer.chooseUse(Outcome.Benefit, winner.getLogName() + " has bet " + highBid + " life. Top the bid?", source, game)) {
                        newBid = currentPlayer.getAmount(highBid + 1, Integer.MAX_VALUE, "Choose bid", source, game);
                    }
                    if (newBid <= highBid) break;
                    highBid = newBid;
                    winner = currentPlayer;
                    game.informPlayers(currentPlayer.getLogName() + " has bet " + newBid + " life");
                    Player player = currentPlayer = winner == you ? spellController : you;
                } while (you.canRespond() && spellController.canRespond() && !Objects.equals(currentPlayer, winner));
                game.informPlayers(winner.getLogName() + " has won the contest with a high bid of " + highBid + " life");
                winner.loseLife(highBid, game, source, false);
                if (winner == you) {
                    game.getStack().counter(spell.getId(), source, game);
                }
                return true;
            }
        }
        return false;
    }
}

