/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageEverythingEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MagmasaurEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creature without flying");

    public MagmasaurEffect() {
        super(Outcome.Damage);
        this.staticText = "you may remove a +1/+1 counter from {this}. If you don't, sacrifice {this} and it deals damage equal to the number of +1/+1 counters on it to each creature without flying and each player";
    }

    private MagmasaurEffect(MagmasaurEffect effect) {
        super((OneShotEffect)effect);
    }

    public MagmasaurEffect copy() {
        return new MagmasaurEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourceObject = source.getSourcePermanentIfItStillExists(game);
        if (sourceObject != null && controller != null) {
            if (controller.chooseUse(this.outcome, "Remove a +1/+1 counter from " + sourceObject.getLogName() + '?', source, game)) {
                sourceObject.removeCounters(CounterType.P1P1.getName(), 1, source, game);
            } else {
                int counters = sourceObject.getCounters(game).getCount(CounterType.P1P1);
                sourceObject.sacrifice(source, game);
                new DamageEverythingEffect(counters, (FilterPermanent)filter).apply(game, source);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add(Predicates.not((Predicate)new AbilityPredicate(FlyingAbility.class)));
    }
}

