/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Set;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.players.Player;
import mage.watchers.common.CastSpellLastTurnWatcher;

class MagusOfTheMindEffect
extends OneShotEffect {
    MagusOfTheMindEffect() {
        super(Outcome.Benefit);
        this.staticText = "Shuffle your library, then exile the top X cards, where X is one plus the number of spells cast this turn. Until end of turn, you may play cards exiled this way without paying their mana costs";
    }

    private MagusOfTheMindEffect(MagusOfTheMindEffect effect) {
        super((OneShotEffect)effect);
    }

    public MagusOfTheMindEffect copy() {
        return new MagusOfTheMindEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        CastSpellLastTurnWatcher watcher = (CastSpellLastTurnWatcher)game.getState().getWatcher(CastSpellLastTurnWatcher.class);
        if (watcher == null) {
            return false;
        }
        int stormCount = watcher.getAmountOfSpellsAllPlayersCastOnCurrentTurn() + 1;
        if (controller != null && sourceObject != null) {
            controller.shuffleLibrary(source, game);
            if (controller.getLibrary().hasCards()) {
                Set cards = controller.getLibrary().getTopCards(game, stormCount);
                return PlayFromNotOwnHandZoneTargetEffect.exileAndPlayFromExile((Game)game, (Ability)source, (Set)cards, (TargetController)TargetController.YOU, (Duration)Duration.EndOfTurn, (boolean)true, (boolean)false, (boolean)false);
            }
            return true;
        }
        return false;
    }
}

