/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.LinkedHashSet;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.effects.common.counter.RemoveCounterTargetEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class MaintenanceDroidEffect
extends OneShotEffect {
    private static final Set<String> choices = new LinkedHashSet<String>();

    public MaintenanceDroidEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Choose target card you own with a repair counter on it. You may remove a repair counter from it or put another repair counter on it";
    }

    private MaintenanceDroidEffect(MaintenanceDroidEffect effect) {
        super((OneShotEffect)effect);
    }

    public MaintenanceDroidEffect copy() {
        return new MaintenanceDroidEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            String chosen;
            ChoiceImpl choice = new ChoiceImpl(true);
            choice.setMessage("Choose mode");
            choice.setChoices(choices);
            if (!controller.choose(this.outcome, (Choice)choice, game)) {
                return false;
            }
            switch (chosen = choice.getChoice()) {
                case "Remove a repair counter": {
                    new RemoveCounterTargetEffect(CounterType.REPAIR.createInstance()).apply(game, source);
                    break;
                }
                default: {
                    new AddCountersTargetEffect(CounterType.REPAIR.createInstance()).apply(game, source);
                }
            }
            return true;
        }
        return false;
    }

    static {
        choices.add("Remove a repair counter");
        choices.add("Add another repair counter");
    }
}

