/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.common.LookLibraryAndPickControllerEffect;
import mage.abilities.keyword.PlotAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.PutCards;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class MakeYourOwnLuckEffect
extends LookLibraryAndPickControllerEffect {
    MakeYourOwnLuckEffect() {
        super(3, 1, (FilterCard)StaticFilters.FILTER_CARD_NON_LAND, PutCards.EXILED, PutCards.HAND);
        this.staticText = "Look at the top three cards of your library. You may exile a nonland card from among them. If you do, it becomes plotted. Put the rest into your hand";
    }

    private MakeYourOwnLuckEffect(MakeYourOwnLuckEffect effect) {
        super((LookLibraryAndPickControllerEffect)effect);
    }

    public MakeYourOwnLuckEffect copy() {
        return new MakeYourOwnLuckEffect(this);
    }

    public boolean actionWithPickedCards(Game game, Ability source, Player player, Cards pickedCards, Cards otherCards) {
        boolean result = false;
        for (Card card : pickedCards.getCards(game)) {
            result |= PlotAbility.doExileAndPlotCard((Card)card, (Game)game, (Ability)source);
        }
        return result |= this.putLookedCards.moveCards(player, otherCards, source, game);
    }
}

