/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.common.BecomesTargetSourceTriggeredAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MakeshiftMannequinGainAbilityEffect
extends ContinuousEffectImpl {
    MakeshiftMannequinGainAbilityEffect() {
        super(Duration.Custom, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
    }

    private MakeshiftMannequinGainAbilityEffect(MakeshiftMannequinGainAbilityEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            permanent.addAbility((Ability)new BecomesTargetSourceTriggeredAbility((Effect)new SacrificeSourceEffect()), source.getSourceId(), game);
            return true;
        }
        return false;
    }

    public boolean isInactive(Ability source, Game game) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        return permanent == null || permanent.getCounters(game).getCount(CounterType.MANNEQUIN) < 1;
    }

    public MakeshiftMannequinGainAbilityEffect copy() {
        return new MakeshiftMannequinGainAbilityEffect(this);
    }
}

