/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Optional;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeOpponentsEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Controllable;
import mage.game.Game;

class MalfegorEffect
extends OneShotEffect {
    MalfegorEffect() {
        super(Outcome.Neutral);
        this.staticText = "discard your hand. Each opponent sacrifices a creature for each card discarded this way";
    }

    private MalfegorEffect(MalfegorEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        return Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(player -> !player.getHand().isEmpty()).map(player -> player.discard(player.getHand(), false, source, game)).map(Set::size).filter(amount -> amount > 0 && new SacrificeOpponentsEffect(amount.intValue(), (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE).apply(game, source)).isPresent();
    }

    public MalfegorEffect copy() {
        return new MalfegorEffect(this);
    }
}

