/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.effects.AsThoughManaEffect;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.ManaPoolItem;

class ManaCanBeSpentAsAnyColorEffect
extends AsThoughEffectImpl
implements AsThoughManaEffect {
    public ManaCanBeSpentAsAnyColorEffect() {
        super(AsThoughEffectType.SPEND_OTHER_MANA, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Players may spend mana as though it were mana of any color";
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        return game.getState().getPlayersInRange(source.getControllerId(), game).contains((Object)affectedControllerId);
    }

    public ManaType getAsThoughManaType(ManaType manaType, ManaPoolItem mana, UUID affectedControllerId, Ability source, Game game) {
        return mana.getFirstAvailable();
    }

    public ManaCanBeSpentAsAnyColorEffect copy() {
        return new ManaCanBeSpentAsAnyColorEffect(this);
    }

    private ManaCanBeSpentAsAnyColorEffect(ManaCanBeSpentAsAnyColorEffect effect) {
        super((AsThoughEffectImpl)effect);
    }
}

