/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.ManaUtil;

class ManaChargedDragonEffect
extends OneShotEffect {
    ManaChargedDragonEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "each player starting with you may pay any amount of mana. {this} gets +X/+0 until end of turn, where X is the total amount of mana paid this way";
    }

    private ManaChargedDragonEffect(ManaChargedDragonEffect effect) {
        super((OneShotEffect)effect);
    }

    public ManaChargedDragonEffect copy() {
        return new ManaChargedDragonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int xSum = 0;
            xSum += ManaUtil.playerPaysXGenericMana((boolean)false, (String)"Mana Charged Dragon", (Player)controller, (Ability)source, (Game)game);
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player;
                if (Objects.equals(playerId, controller.getId()) || (player = game.getPlayer(playerId)) == null || !player.canRespond()) continue;
                xSum += ManaUtil.playerPaysXGenericMana((boolean)false, (String)"Mana Charged Dragon", (Player)player, (Ability)source, (Game)game);
            }
            if (xSum > 0) {
                BoostSourceEffect effect = new BoostSourceEffect(xSum, 0, Duration.EndOfTurn);
                game.addEffect((ContinuousEffect)effect, source);
            }
            controller.resetStoredBookmark(game);
            return true;
        }
        return false;
    }
}

