/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class ManaSeveranceEffect
extends OneShotEffect {
    ManaSeveranceEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library for any number of land cards, exile them, then shuffle";
    }

    private ManaSeveranceEffect(ManaSeveranceEffect effect) {
        super((OneShotEffect)effect);
    }

    public ManaSeveranceEffect copy() {
        return new ManaSeveranceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(0, Integer.MAX_VALUE, (FilterCard)StaticFilters.FILTER_CARD_LANDS);
        player.searchLibrary(target, source, game);
        CardsImpl cards = new CardsImpl((Collection)target.getTargets());
        cards.retainZone(Zone.LIBRARY, game);
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        player.shuffleLibrary(source, game);
        return true;
    }
}

