/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.DragonIllusionToken;
import mage.game.permanent.token.Token;
import mage.game.stack.Spell;
import mage.watchers.common.ManaPaidSourceWatcher;

class ManaformHellkitEffect
extends OneShotEffect {
    ManaformHellkitEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create an X/X red Dragon Illusion creature token with flying and haste, where X is the amount of mana spent to cast that spell. Exile that token at the beginning of the next end step";
    }

    private ManaformHellkitEffect(ManaformHellkitEffect effect) {
        super((OneShotEffect)effect);
    }

    public ManaformHellkitEffect copy() {
        return new ManaformHellkitEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CreateTokenEffect effect;
        Spell spell = (Spell)this.getValue("spellCast");
        if (spell != null && (effect = new CreateTokenEffect((Token)new DragonIllusionToken(ManaPaidSourceWatcher.getTotalPaid((UUID)spell.getId(), (Game)game)))).apply(game, source)) {
            effect.exileTokensCreatedAtNextEndStep(game, source);
            return true;
        }
        return false;
    }
}

