/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.BasicManaAbility;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ManascapeRefractorGainAbilitiesEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterLandPermanent();

    ManascapeRefractorGainAbilitiesEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "{this} has all activated abilities of all lands on the battlefield.";
        this.addDependencyType(DependencyType.AddingAbility);
    }

    private ManascapeRefractorGainAbilitiesEffect(ManascapeRefractorGainAbilitiesEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent perm = game.getPermanent(source.getSourceId());
        if (perm == null) {
            return false;
        }
        for (Ability ability : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game).stream().map(permanent -> permanent.getAbilities(game)).flatMap(Collection::stream).filter(Objects::nonNull).filter(Ability::isActivatedAbility).collect(Collectors.toList())) {
            if (ability instanceof BasicManaAbility) {
                if (!perm.getAbilities(game).stream().noneMatch(ability.getClass()::isInstance)) continue;
            }
            perm.addAbility(ability, source.getSourceId(), game, true);
        }
        return true;
    }

    public ManascapeRefractorGainAbilitiesEffect copy() {
        return new ManascapeRefractorGainAbilitiesEffect(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

