/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class MandateOfPeaceOpponentsCantCastSpellsEffect
extends ContinuousRuleModifyingEffectImpl {
    MandateOfPeaceOpponentsCantCastSpellsEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "Your opponents can't cast spells this turn";
    }

    private MandateOfPeaceOpponentsCantCastSpellsEffect(MandateOfPeaceOpponentsCantCastSpellsEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public MandateOfPeaceOpponentsCantCastSpellsEffect copy() {
        return new MandateOfPeaceOpponentsCantCastSpellsEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't cast spells this turn (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return game.getOpponents(source.getControllerId()).contains(event.getPlayerId());
    }
}

