/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MaraudingRaptorEffect
extends OneShotEffect {
    MaraudingRaptorEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 2 damage to it. If a Dinosaur is dealt damage this way, {this} gets +2/+0 until end of turn";
    }

    private MaraudingRaptorEffect(MaraudingRaptorEffect effect) {
        super((OneShotEffect)effect);
    }

    public MaraudingRaptorEffect copy() {
        return new MaraudingRaptorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        if (permanent.damage(2, source.getSourceId(), source, game) > 0 && permanent.hasSubtype(SubType.DINOSAUR, game)) {
            game.addEffect((ContinuousEffect)new BoostSourceEffect(2, 0, Duration.EndOfTurn), source);
        }
        return true;
    }
}

