/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.keyword.AmassEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class MarchFromTheBlackGateTriggeredAbility
extends TriggeredAbilityImpl {
    MarchFromTheBlackGateTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AmassEffect(1, SubType.ORC));
        this.setTriggerPhrase("When {this} enters and whenever an Army you control attacks, ");
    }

    private MarchFromTheBlackGateTriggeredAbility(MarchFromTheBlackGateTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MarchFromTheBlackGateTriggeredAbility copy() {
        return new MarchFromTheBlackGateTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case ENTERS_THE_BATTLEFIELD: 
            case ATTACKER_DECLARED: {
                return true;
            }
        }
        return false;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        switch (event.getType()) {
            case ENTERS_THE_BATTLEFIELD: {
                return event.getTargetId().equals(this.getSourceId());
            }
            case ATTACKER_DECLARED: {
                Permanent permanent = game.getPermanent(event.getSourceId());
                return permanent != null && permanent.hasSubtype(SubType.ARMY, game) && permanent.isControlledBy(this.getControllerId());
            }
        }
        return false;
    }
}

