/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledLandPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class MarchFromVelisVelEffect
extends OneShotEffect {
    MarchFromVelisVelEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a nonbasic land type. Each land you control of that type becomes a copy of target creature you control until end of turn and gains haste until end of turn";
    }

    private MarchFromVelisVelEffect(MarchFromVelisVelEffect effect) {
        super((OneShotEffect)effect);
    }

    public MarchFromVelisVelEffect copy() {
        return new MarchFromVelisVelEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null) {
            return false;
        }
        ChoiceImpl choice = new ChoiceImpl(true);
        choice.setMessage("Choose a nonbasic land type");
        choice.setChoices(SubType.getNonbasicLandTypes().stream().map(SubType::toString).collect(Collectors.toSet()));
        player.choose(this.outcome, (Choice)choice, game);
        SubType subType = SubType.byDescription((String)choice.getChoice());
        if (subType == null) {
            return false;
        }
        FilterControlledLandPermanent filter = new FilterControlledLandPermanent(subType, "");
        List permanents = game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game);
        if (permanents.isEmpty()) {
            return false;
        }
        for (Permanent land : permanents) {
            game.copyPermanent(Duration.EndOfTurn, permanent, land.getId(), source, (CopyApplier)new EmptyCopyApplier());
        }
        game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance()).setTargetPointer((TargetPointer)new FixedTargets((Collection)permanents, game)), source);
        return true;
    }
}

