/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashMap;
import java.util.Map;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class MarchOfRecklessJoyWatcher
extends Watcher {
    private final Map<MageObjectReference, Integer> morMap = new HashMap<MageObjectReference, Integer>();

    public MarchOfRecklessJoyWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST || event.getApprovingObject() == null) {
            return;
        }
        this.morMap.compute(event.getApprovingObject().getApprovingMageObjectReference(), CardUtil::setOrIncrementValue);
    }

    static boolean check(Ability source, Game game) {
        return ((MarchOfRecklessJoyWatcher)game.getState().getWatcher(MarchOfRecklessJoyWatcher.class)).morMap.getOrDefault(new MageObjectReference(source, 1), 0) < 2;
    }
}

