/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.WarriorToken;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MarduCharmCreateTokenEffect
extends OneShotEffect {
    MarduCharmCreateTokenEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create two 1/1 white Warrior creature tokens. They gain first strike until end of turn";
    }

    private MarduCharmCreateTokenEffect(MarduCharmCreateTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public MarduCharmCreateTokenEffect copy() {
        return new MarduCharmCreateTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CreateTokenEffect effect = new CreateTokenEffect((Token)new WarriorToken(), 2);
            effect.apply(game, source);
            for (UUID tokenId : effect.getLastAddedTokenIds()) {
                Permanent token = game.getPermanent(tokenId);
                if (token == null) continue;
                GainAbilityTargetEffect continuousEffect = new GainAbilityTargetEffect((Ability)FirstStrikeAbility.getInstance(), Duration.EndOfTurn);
                continuousEffect.setTargetPointer((TargetPointer)new FixedTarget(tokenId));
                game.addEffect((ContinuousEffect)continuousEffect, source);
            }
            return true;
        }
        return false;
    }
}

