/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.MenaceAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.RedWarriorToken;
import mage.game.permanent.token.Token;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class MarduMonumentEffect
extends OneShotEffect {
    MarduMonumentEffect() {
        super(Outcome.Benefit);
        this.staticText = "create three 1/1 red Warrior creature tokens. They gain menace and haste until end of turn";
    }

    private MarduMonumentEffect(MarduMonumentEffect effect) {
        super((OneShotEffect)effect);
    }

    public MarduMonumentEffect copy() {
        return new MarduMonumentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        RedWarriorToken token = new RedWarriorToken();
        token.putOntoBattlefield(3, game, source);
        game.addEffect(new GainAbilityTargetEffect((Ability)new MenaceAbility(false), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTargets((Token)token, game)), source);
        game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTargets((Token)token, game)), source);
        return true;
    }
}

