/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.m.MariTheKillingQuillExileCreatureEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MariTheKillingQuillCreatureDiesAbility
extends TriggeredAbilityImpl {
    public MariTheKillingQuillCreatureDiesAbility() {
        super(Zone.BATTLEFIELD, (Effect)new MariTheKillingQuillExileCreatureEffect(), false);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private MariTheKillingQuillCreatureDiesAbility(MariTheKillingQuillCreatureDiesAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MariTheKillingQuillCreatureDiesAbility copy() {
        return new MariTheKillingQuillCreatureDiesAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent creature;
        if (((ZoneChangeEvent)event).isDiesEvent() && game.getOpponents(this.controllerId).contains(event.getPlayerId()) && (creature = game.getPermanentOrLKIBattlefield(event.getTargetId())) != null && creature.isCreature(game)) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(creature.getId(), game));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature an opponent controls dies, exile it with a hit counter on it.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

