/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Iterator;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MarshCasualtiesEffect
extends ContinuousEffectImpl {
    private final int power;
    private final int toughness;

    public MarshCasualtiesEffect(int power, int toughness) {
        super(Duration.EndOfTurn, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.power = power;
        this.toughness = toughness;
    }

    private MarshCasualtiesEffect(MarshCasualtiesEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.power = effect.power;
        this.toughness = effect.toughness;
    }

    public MarshCasualtiesEffect copy() {
        return new MarshCasualtiesEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.getAffectedObjectsSet()) {
            for (Permanent creature : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, source.getFirstTarget(), game)) {
                this.affectedObjectList.add(new MageObjectReference((MageObject)creature, game));
            }
        }
    }

    public boolean apply(Game game, Ability source) {
        Iterator it = this.affectedObjectList.iterator();
        while (it.hasNext()) {
            Permanent permanent = ((MageObjectReference)it.next()).getPermanent(game);
            if (permanent != null) {
                permanent.addPower(this.power);
                permanent.addToughness(this.toughness);
                continue;
            }
            it.remove();
        }
        return true;
    }
}

