/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceIsSpellCondition;
import mage.abilities.costs.AlternativeCostSourceAbility;
import mage.abilities.costs.DynamicCost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.m.MarshlandBloodcasterCost;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.watchers.common.SpellsCastWatcher;

class MarshlandBloodcasterEffect
extends ContinuousEffectImpl {
    private static final FilterCard filter = new FilterCard("a spell");
    private final AlternativeCostSourceAbility alternativeCastingCostAbility = new AlternativeCostSourceAbility((Condition)SourceIsSpellCondition.instance, null, filter, true, (DynamicCost)MarshlandBloodcasterCost.instance);
    private int spellsCast = -1;

    public MarshlandBloodcasterEffect() {
        super(Duration.EndOfTurn, Layer.RulesEffects, SubLayer.NA, Outcome.Detriment);
        this.staticText = "rather than pay the mana cost of the next spell you cast this turn, you may pay life equal to that spell's mana value";
    }

    private MarshlandBloodcasterEffect(MarshlandBloodcasterEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.spellsCast = effect.spellsCast;
    }

    public MarshlandBloodcasterEffect copy() {
        return new MarshlandBloodcasterEffect(this);
    }

    public void init(Ability source, Game game, UUID activePlayerId) {
        super.init(source, game, activePlayerId);
        this.alternativeCastingCostAbility.setSourceId(source.getSourceId());
        this.spellsCast = MarshlandBloodcasterEffect.getSpellsCast(source.getControllerId(), game);
    }

    public boolean apply(Game game, Ability source) {
        if (MarshlandBloodcasterEffect.getSpellsCast(source.getControllerId(), game) > this.spellsCast) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.getAlternativeSourceCosts().add(this.alternativeCastingCostAbility);
        return true;
    }

    private static int getSpellsCast(UUID playerId, Game game) {
        SpellsCastWatcher watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class);
        return watcher != null ? watcher.getCount(playerId) : 0;
    }
}

