/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.SoldierToken;
import mage.util.CardUtil;

class MartialCoupEffect
extends OneShotEffect {
    private static SoldierToken token = new SoldierToken();

    public MartialCoupEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create X 1/1 white Soldier creature tokens. If X is 5 or more, destroy all other creatures";
    }

    private MartialCoupEffect(MartialCoupEffect effect) {
        super((OneShotEffect)effect);
    }

    public MartialCoupEffect copy() {
        return new MartialCoupEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int amount = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        token.putOntoBattlefield(amount, game, source, source.getControllerId());
        List tokens = token.getLastAddedTokenIds();
        if (amount > 4) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, source.getControllerId(), game)) {
                if (tokens.contains(permanent.getId())) continue;
                permanent.destroy(source, game, false);
            }
        }
        return true;
    }
}

