/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.ActivatedAbility;
import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.cards.m.MartyrdomRedirectDamageTargetEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;

class MartyrdomActivatedAbility
extends ActivatedAbilityImpl {
    private UUID caster;

    public MartyrdomActivatedAbility(UUID caster) {
        super(Zone.BATTLEFIELD, (Effect)new MartyrdomRedirectDamageTargetEffect(Duration.EndOfTurn, 1), (Cost)new GenericManaCost(0));
        this.addTarget((Target)new TargetAnyTarget());
        this.caster = caster;
    }

    private MartyrdomActivatedAbility(MartyrdomActivatedAbility ability) {
        super((ActivatedAbilityImpl)ability);
        this.caster = ability.caster;
    }

    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        if (!playerId.equals(this.caster)) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        Permanent permanent = game.getPermanent(this.getSourceId());
        if (permanent == null || !permanent.isCreature(game)) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        return super.canActivate(playerId, game);
    }

    public MartyrdomActivatedAbility copy() {
        return new MartyrdomActivatedAbility(this);
    }

    public String getRule() {
        return "{0}: The next 1 damage that would be dealt to target creature, planeswalker, or player this turn is dealt to {this} instead.";
    }
}

