/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.SharesCardTypePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class MartyrsBondEffect
extends OneShotEffect {
    MartyrsBondEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "each opponent sacrifices a permanent that shares a card type with it";
    }

    private MartyrsBondEffect(MartyrsBondEffect effect) {
        super((OneShotEffect)effect);
    }

    public MartyrsBondEffect copy() {
        return new MartyrsBondEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<UUID> perms = new ArrayList<UUID>();
        if (source != null) {
            Permanent saccedPermanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
            Player controller = game.getPlayer(source.getControllerId());
            if (controller != null && saccedPermanent != null) {
                SharesCardTypePredicate predicate = new SharesCardTypePredicate((Collection)saccedPermanent.getCardType(game));
                FilterControlledPermanent filter = new FilterControlledPermanent(predicate.toString());
                filter.add((Predicate)predicate);
                for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                    TargetSacrifice target;
                    Player player = game.getPlayer(playerId);
                    if (player == null || playerId.equals(controller.getId()) || !(target = new TargetSacrifice((FilterPermanent)filter)).canChoose(playerId, source, game)) continue;
                    player.choose(Outcome.Sacrifice, (Target)target, source, game);
                    perms.add(target.getFirstTarget());
                }
                boolean saccedPermaents = false;
                for (UUID permID : perms) {
                    Permanent permanent = game.getPermanent(permID);
                    if (permanent == null) continue;
                    permanent.sacrifice(source, game);
                    saccedPermaents = true;
                }
                return saccedPermaents;
            }
        }
        return false;
    }
}

