/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceTargetsPermanentCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.UntapTargetEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.abilities.effects.common.cost.SpellCostReductionSourceEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class MascotInterception
extends CardImpl {
    private static final FilterPermanent filter = new FilterCreaturePermanent("a creature token");
    private static final Condition condition;

    public MascotInterception(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{3}{R}");
        this.addAbility(new SimpleStaticAbility(Zone.ALL, (Effect)new SpellCostReductionSourceEffect(3, condition).setCanWorksOnStackOnly(true)).setRuleAtTheTop(true));
        this.getSpellAbility().addEffect((Effect)new GainControlTargetEffect(Duration.EndOfTurn));
        this.getSpellAbility().addEffect((Effect)new UntapTargetEffect().setText("Untap that creature"));
        this.getSpellAbility().addEffect((Effect)new BoostTargetEffect(2, 0, Duration.EndOfTurn).setText("It gets +2/+0"));
        this.getSpellAbility().addEffect((Effect)new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn).setText("and gains haste until end of turn"));
        this.getSpellAbility().addTarget((Target)new TargetCreaturePermanent());
    }

    private MascotInterception(MascotInterception card) {
        super((CardImpl)card);
    }

    public MascotInterception copy() {
        return new MascotInterception(this);
    }

    static {
        filter.add((Predicate)TokenPredicate.TRUE);
        condition = new SourceTargetsPermanentCondition(filter);
    }
}

