/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.command.Commander;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.util.CardUtil;

class MaskwoodNexusEffect
extends ContinuousEffectImpl {
    MaskwoodNexusEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.staticText = "Creatures you control are every creature type. The same is true for creature spells you control and creature cards you own that aren't on the battlefield.";
        this.dependendToTypes.add(DependencyType.BecomeCreature);
    }

    private MaskwoodNexusEffect(MaskwoodNexusEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public MaskwoodNexusEffect copy() {
        return new MaskwoodNexusEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Set affectedCards = controller.getGraveyard().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        controller.getHand().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).forEach(affectedCards::add);
        game.getState().getExile().getCardsOwned(game, controller.getId()).stream().filter(card -> card.isOwnedBy(controller.getId())).forEach(affectedCards::add);
        affectedCards.addAll(controller.getLibrary().getCards(game));
        game.getState().getCommand().stream().filter(Commander.class::isInstance).map(MageItem::getId).map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).filter(c -> c.isOwnedBy(controller.getId())).forEach(affectedCards::add);
        affectedCards.stream().map(card -> game.getObject(card.getId())).filter(Objects::nonNull).forEach(mageObject -> {
            if (mageObject.isCreature(game)) {
                game.getState().getCreateMageObjectAttribute(mageObject, game).getSubtype().setIsAllCreatureTypes(true);
            }
            CardUtil.getObjectParts((MageObject)mageObject).stream().filter(Objects::nonNull).forEach(objectId -> {
                MageObject partObject = game.getObject(objectId);
                if (partObject != null && partObject.isCreature(game)) {
                    game.getState().getCreateMageObjectAttribute(partObject, game).getSubtype().setIsAllCreatureTypes(true);
                }
            });
        });
        for (StackObject stackObject : game.getStack()) {
            if (!(stackObject instanceof Spell) || !stackObject.isControlledBy(source.getControllerId()) || !stackObject.isCreature(game)) continue;
            Card card2 = ((Spell)stackObject).getCard();
            game.getState().getCreateMageObjectAttribute((MageObject)card2, game).getSubtype().setIsAllCreatureTypes(true);
        }
        List creatures = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), game);
        for (Permanent creature : creatures) {
            if (creature == null) continue;
            creature.setIsAllCreatureTypes(game, true);
        }
        return true;
    }
}

