/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MassacreWurmTriggeredAbility
extends TriggeredAbilityImpl {
    MassacreWurmTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new LoseLifeTargetEffect(2));
        this.setTriggerPhrase("Whenever a creature an opponent controls dies, ");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private MassacreWurmTriggeredAbility(MassacreWurmTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MassacreWurmTriggeredAbility copy() {
        return new MassacreWurmTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent p;
        if (((ZoneChangeEvent)event).isDiesEvent() && (p = (Permanent)game.getLastKnownInformation(event.getTargetId(), Zone.BATTLEFIELD)) != null && p.isCreature(game) && game.getOpponents(this.getControllerId()).contains(p.getControllerId())) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(p.getControllerId()));
            }
            return true;
        }
        return false;
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

