/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class MasterOfWindsEffect
extends OneShotEffect {
    MasterOfWindsEffect() {
        super(Outcome.Benefit);
        this.staticText = "have {this}'s base power and toughness become 4/1 or 1/4 until end of turn";
    }

    private MasterOfWindsEffect(MasterOfWindsEffect effect) {
        super((OneShotEffect)effect);
    }

    public MasterOfWindsEffect copy() {
        return new MasterOfWindsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int power = player.chooseUse(Outcome.Neutral, "Have this creature become a 4/1 or a 1/4?", null, "4/1", "1/4", source, game) ? 4 : 1;
        game.addEffect((ContinuousEffect)new SetBasePowerToughnessSourceEffect(power, 5 - power, Duration.EndOfTurn), source);
        return true;
    }
}

