/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Controllable;
import mage.game.Game;
import mage.target.Target;
import mage.util.CardUtil;

class MavindaStudentsAdvocateCostEffect
extends CostModificationEffectImpl {
    private final MageObjectReference mor;

    MavindaStudentsAdvocateCostEffect(Card card, Game game) {
        super(Duration.EndOfTurn, Outcome.Benefit, CostModificationType.INCREASE_COST);
        this.mor = new MageObjectReference((MageObject)card, game, 1);
    }

    private MavindaStudentsAdvocateCostEffect(MavindaStudentsAdvocateCostEffect effect) {
        super((CostModificationEffectImpl)effect);
        this.mor = effect.mor;
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.increaseCost((Ability)abilityToModify, (int)8);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (!(abilityToModify instanceof SpellAbility)) return false;
        if (!abilityToModify.isControlledBy(source.getControllerId())) return false;
        if (!this.mor.refersTo(CardUtil.getMainCardId((Game)game, (UUID)abilityToModify.getSourceId()), game)) return false;
        if (!abilityToModify.getTargets().stream().map(Target::getTargets).flatMap(Collection::stream).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).filter(permanent -> permanent.isCreature(game)).map(Controllable::getControllerId).noneMatch(arg_0 -> ((Ability)source).isControlledBy(arg_0))) return false;
        return true;
    }

    public MavindaStudentsAdvocateCostEffect copy() {
        return new MavindaStudentsAdvocateCostEffect(this);
    }
}

