/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MaximumCarnageEffect
extends RestrictionEffect {
    MaximumCarnageEffect() {
        super(Duration.UntilYourNextTurn);
        this.staticText = "and attacks a player other than you if able";
    }

    private MaximumCarnageEffect(MaximumCarnageEffect effect) {
        super((RestrictionEffect)effect);
    }

    public MaximumCarnageEffect copy() {
        return new MaximumCarnageEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return game.getOpponents(permanent.getControllerId()).contains(source.getControllerId());
    }

    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        if (defenderId == null || game.getState().getPlayersInRange(attacker.getControllerId(), game).size() == 2) {
            return true;
        }
        if (game.getPermanent(defenderId) != null) {
            return !game.getPermanent(defenderId).getControllerId().equals(source.getControllerId());
        }
        return !defenderId.equals(source.getControllerId());
    }
}

