/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.MageIdentifier;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.StaticAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCounterChoiceSourceEffect;
import mage.abilities.triggers.BeginningOfCombatTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.m.MeTheImmortalCastEffect;
import mage.cards.m.MeTheImmortalEffect;
import mage.constants.CardType;
import mage.constants.EffectType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.game.Game;
import mage.game.events.ZoneChangeEvent;

public final class MeTheImmortal
extends CardImpl {
    public MeTheImmortal(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{2}{G}{U}{R}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.HUMAN);
        this.subtype.add((Object)SubType.ROGUE);
        this.power = new MageInt(3);
        this.toughness = new MageInt(3);
        this.addAbility((Ability)new BeginningOfCombatTriggeredAbility((Effect)new AddCounterChoiceSourceEffect(new CounterType[]{CounterType.P1P1, CounterType.FIRST_STRIKE, CounterType.VIGILANCE, CounterType.MENACE}).setText("put your choice of a +1/+1, first strike, vigilance, or menace counter on {this}")));
        this.addAbility((Ability)new SimpleStaticAbility(Zone.ALL, (Effect)new MeTheImmortalEffect()));
        this.addAbility((Ability)new SimpleStaticAbility(Zone.ALL, (Effect)new MeTheImmortalCastEffect()).setIdentifier(MageIdentifier.MeTheImmortalAlternateCast));
    }

    private MeTheImmortal(MeTheImmortal card) {
        super((CardImpl)card);
    }

    public MeTheImmortal copy() {
        return new MeTheImmortal(this);
    }

    public void updateZoneChangeCounter(Game game, ZoneChangeEvent event) {
        boolean skullBriarEffectApplied = false;
        if (event.getToZone() != Zone.HAND && event.getToZone() != Zone.LIBRARY) {
            for (StaticAbility ability : this.getAbilities(game).getStaticAbilities(event.getFromZone())) {
                for (Effect effect : ability.getEffects(game, EffectType.REPLACEMENT)) {
                    if (!(effect instanceof MeTheImmortalEffect) || !event.getAppliedEffects().contains(effect.getId())) continue;
                    skullBriarEffectApplied = true;
                }
            }
        }
        Counters copyFrom = null;
        if (skullBriarEffectApplied) {
            copyFrom = event.getTarget() != null && event.getFromZone() == Zone.BATTLEFIELD ? event.getTarget().getCounters(game).copy() : this.getCounters(game).copy();
        }
        super.updateZoneChangeCounter(game, event);
        Counters copyTo = null;
        if (event.getTarget() != null && event.getToZone() == Zone.BATTLEFIELD) {
            if (event.getFromZone() != Zone.BATTLEFIELD) {
                copyTo = event.getTarget().getCounters(game);
            }
        } else {
            copyTo = this.getCounters(game);
        }
        if (copyTo != null && copyFrom != null) {
            for (Counter counter : copyFrom.values()) {
                copyTo.addCounter(counter);
            }
        }
    }
}

