/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldWithCounterTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MeathookMassacreIIEffect
extends OneShotEffect {
    MeathookMassacreIIEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "they may pay 3 life. If they don't, return that card under your control with a finality counter on it";
    }

    private MeathookMassacreIIEffect(MeathookMassacreIIEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = this.getTargetPointer().getControllerOfFirstTargetOrLKI(game, source);
        if (player == null) {
            return false;
        }
        PayLifeCost cost = new PayLifeCost(3);
        if (player.chooseUse(Outcome.Detriment, "Pay 3 life to prevent this effect?", source, game) && cost.pay(source, game, source, player.getId(), true)) {
            return true;
        }
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card == null) {
            return true;
        }
        new ReturnFromGraveyardToBattlefieldWithCounterTargetEffect(new Counter[]{CounterType.FINALITY.createInstance()}).setTargetPointer((TargetPointer)new FixedTarget(card, game)).apply(game, source);
        return true;
    }

    public MeathookMassacreIIEffect copy() {
        return new MeathookMassacreIIEffect(this);
    }
}

