/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class MechanizedWarfareEffect
extends ReplacementEffectImpl {
    MechanizedWarfareEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "If a red or artifact source you control would deal damage to an opponent or a permanent an opponent controls, it deals that much damage plus 1 instead.";
    }

    private MechanizedWarfareEffect(MechanizedWarfareEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)1));
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PERMANENT: 
            case DAMAGE_PLAYER: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || !controller.hasOpponent(MechanizedWarfareEffect.getControllerOrSelf(event.getTargetId(), game), game) || !source.isControlledBy(game.getControllerId(event.getSourceId()))) {
            return false;
        }
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        Object sourceObject = sourcePermanent == null ? game.getObject(event.getSourceId()) : sourcePermanent;
        return sourceObject != null && event.getAmount() > 0 && (sourceObject.getColor(game).isRed() || sourceObject.isArtifact(game));
    }

    private static UUID getControllerOrSelf(UUID id, Game game) {
        UUID outId = game.getControllerId(id);
        return outId == null ? id : outId;
    }

    public MechanizedWarfareEffect copy() {
        return new MechanizedWarfareEffect(this);
    }
}

