/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.m.MeetingOfTheFiveCastEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class MeetingOfTheFiveExileEffect
extends OneShotEffect {
    MeetingOfTheFiveExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top ten cards of your library. You may cast spells with exactly three colors from among them this turn";
    }

    private MeetingOfTheFiveExileEffect(MeetingOfTheFiveExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public MeetingOfTheFiveExileEffect copy() {
        return new MeetingOfTheFiveExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 10));
        if (cards.isEmpty()) {
            return false;
        }
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        for (Card card : cards.getCards(game)) {
            game.addEffect((ContinuousEffect)new MeetingOfTheFiveCastEffect(game, card), source);
        }
        return true;
    }
}

