/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.RemoveFromCombatTargetEffect;
import mage.abilities.effects.common.UntapTargetEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MeleeTriggeredAbility
extends DelayedTriggeredAbility {
    public MeleeTriggeredAbility() {
        super((Effect)new UntapTargetEffect(), Duration.EndOfCombat, false);
        this.addEffect((Effect)new RemoveFromCombatTargetEffect());
    }

    private MeleeTriggeredAbility(MeleeTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNBLOCKED_ATTACKER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null) {
            for (CombatGroup combatGroup : game.getCombat().getGroups()) {
                if (!combatGroup.getBlockers().isEmpty() || !combatGroup.getAttackers().contains(event.getTargetId())) continue;
                this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                return true;
            }
        }
        return false;
    }

    public MeleeTriggeredAbility copy() {
        return new MeleeTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a creature attacks and isn't blocked this combat, untap it and remove it from combat.";
    }
}

