/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class MeltdownEffect
extends OneShotEffect {
    MeltdownEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy each artifact with mana value X or less";
    }

    private MeltdownEffect(MeltdownEffect effect) {
        super((OneShotEffect)effect);
    }

    public MeltdownEffect copy() {
        return new MeltdownEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(source.getControllerId(), game)) {
            if (permanent == null || !permanent.isArtifact(game) || permanent.getManaValue() > (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)) continue;
            permanent.destroy(source, game, false);
        }
        return true;
    }
}

