/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTopXMayPlayUntilEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class MemorialVaultEffect
extends OneShotEffect {
    MemorialVaultEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top X cards of your library, where X is one plus the mana value of the sacrificed artifact. You may play those cards this turn";
    }

    private MemorialVaultEffect(MemorialVaultEffect effect) {
        super((OneShotEffect)effect);
    }

    public MemorialVaultEffect copy() {
        return new MemorialVaultEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int xValue = 1 + CardUtil.castStream((Collection)source.getCosts(), SacrificeTargetCost.class).map(SacrificeTargetCost::getPermanents).flatMap(Collection::stream).mapToInt(MageObject::getManaValue).sum();
        return new ExileTopXMayPlayUntilEffect(xValue, Duration.EndOfTurn).apply(game, source);
    }
}

