/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.discard.DiscardCardYouChooseTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.filter.predicate.mageobject.AdventurePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;

class MemoryTheftEffect
extends OneShotEffect {
    MemoryTheftEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target opponent reveals their hand. You choose a nonland card from it. That player discards that card. You may put a card that has an Adventure that player owns from exile into that player's graveyard.";
    }

    private MemoryTheftEffect(MemoryTheftEffect effect) {
        super((OneShotEffect)effect);
    }

    public MemoryTheftEffect copy() {
        return new MemoryTheftEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        new DiscardCardYouChooseTargetEffect((FilterCard)StaticFilters.FILTER_CARD_NON_LAND).apply(game, source);
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        if (controller == null || player == null) {
            return false;
        }
        FilterCard filter = new FilterCard("card owned by " + player.getName() + " that has an Adventure");
        filter.add((Predicate)AdventurePredicate.instance);
        filter.add((Predicate)new OwnerIdPredicate(player.getId()));
        TargetCardInExile target = new TargetCardInExile(0, 1, filter);
        if (!target.canChoose(source.getControllerId(), source, game) || !controller.choose(this.outcome, (Target)target, source, game)) {
            return false;
        }
        Card card = game.getCard(target.getFirstTarget());
        return controller.moveCards(card, Zone.GRAVEYARD, source, game);
    }
}

