/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MenacingOgreEffect
extends OneShotEffect {
    MenacingOgreEffect() {
        super(Outcome.Detriment);
        this.staticText = "each player secretly chooses a number. Then those numbers are revealed. Each player with the highest number loses that much life. If you are one of those players, put two +1/+1 counters on {this}";
    }

    private MenacingOgreEffect(MenacingOgreEffect effect) {
        super((OneShotEffect)effect);
    }

    public MenacingOgreEffect copy() {
        return new MenacingOgreEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        int highestNumber = 0;
        int number = 0;
        Permanent menacingOgre = game.getPermanent(source.getSourceId());
        String message = "Choose a number.";
        HashMap<Player, Integer> numberChosen = new HashMap<Player, Integer>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            number = player.getAmount(0, 1000, message, source, game);
            numberChosen.put(player, number);
        }
        for (Player player2 : numberChosen.keySet()) {
            if (highestNumber >= (Integer)numberChosen.get(player2)) continue;
            highestNumber = (Integer)numberChosen.get(player2);
        }
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            game.informPlayers(player.getLogName() + " chose number " + numberChosen.get(player));
            if ((Integer)numberChosen.get(player) < highestNumber) continue;
            player.loseLife(highestNumber, game, source, false);
            if (!player.getId().equals(source.getControllerId()) || menacingOgre == null) continue;
            menacingOgre.addCounters(CounterType.P1P1.createInstance(2), source.getControllerId(), source, game);
        }
        return true;
    }
}

